const
	 Path ='D:\DATA\';								//Base path
	 PathU ='D:\DATA\Utilities\'; 		 				//default Utilities directory
	 PathR ='D:\DATA\Utilities\XYarrayNEW\';		//default directory for polar images    		  
	 DM ='M512.tif';								//default Mask
  	 Prompt = 'Select an image for calculation' ;	  
	 
		  CommonDlgsLib = 'VppCommonDlgs.dll' ;		// declaration of CommonDialog constant 

//Windows API constants
  		  wm_Close 		= 16 ;
		  wm_SysCommand = $0112 ; 
		  sc_Close 		= 61536 ;		  	  		// command to close Excel
		  

		  { Declaration of external DLL functions }
		  function OpenDialog( FileName,Title,Filter,DefaultExt:pointer ) : integer ; external CommonDlgsLib ;		  
		  function FindWindow( ClassName,WindowName:pointer ) : integer ;
		  external 'User32' ; name 'FindWindowA' ;

		  procedure SendMessage( Handle,Message,wParam,lParam:integer ) ; 
		  external 'User32' ; name 'SendMessageA' ;		  
		  
		  
{************************************************************************}
{ ***	                      Global variable declaration			  ***}									   
{************************************************************************}

var
   i,j, k, m;										//indices
   Img, iNam;								 		//Experimental image, extended and short names
   xS, yS, zS;							 		 	//original image Size
   nCOL, nROW;										//number of colomns and rows in Combo imaage
   Combo;  											//Combo image		   
   NROI;											//selected frame
   Gap;												//separation gap
   xB,xE,yB,yE;										//coordinates for current image
   Min,Max;
   
{************************************************************************}
{ ***	                      Function GetOpenFileName 				  ***}									   
{************************************************************************}
{This function returns a full name of selected file }		  
   
function GetOpenFileName(Title,Filter,DefaultExt ) ;
{ Open the common Open dialog box and get a file name }
{ Quit if Cancel is pressed }

  const
  	   BufSize = 255 ;
  
  var
  	   FileName ;

	   begin
	   		SetDir(Path);
  	 		FileName := StringOfChar( ' ',BufSize ) ;
  			
		 if OpenDialog( FileName,Title,Filter,DefaultExt ) <> 0 then
     	 	GetOpenFileName := Trim( FileName )
  		else
  			halt('File is NOT selected!!!');  	
end;  { GetOpenFileName }
//----------------------> end of function GetOpenFileName <-------------------------- 


		 
{
 ************************************************************************
 ************************************************************************
 ***                                                                  ***
 ***	                      Main program							  ***
 ***																  ***
 ************************************************************************ 
 ************************************************************************
}		  

		  begin		   
//--------> Get image file
			   iNam:=GetOpenFileName( 'Open','Image Files (*.tif)|*.tif','' );
			   Open(iNam, Img);			  				//open default Mask
			   Show(Img, ExtractFileName(iNam));
			   GetDisplayRange( Img, Min, Max ) ;			   

//--------> Get Size of selected image			   
			   xS:=GetXSize(Img);
			   yS:=GetYSize(Img);					
			   zS:=GetZSize(Img);
					
					nCOL:=4;
					GetNumber('Enter number of COLUMNS', nCOL);
//---------------------------------------------------------------------------------->>>>>Change made -1
					nROW:=Ceil(zs/nCOL){-1};

							i:=0;			
					Gap:=10;


				
				Combo:=CreateImage(TypeOf(Img), Integer((xS)*nCOL+Gap*(nCOL-1)), Integer((yS)*(nROW+1)+Gap*(nRow)));
				Combo:=1;
	
//	WriteInfo(Integer(xS*nCOL+Gap*(nCOL-1)),'  ',Integer(yS*(nROW+1)+Gap*nRow));
//	halt;					
{
						 	yB:=0;
				for m:=0 to nROW do
					begin
						 yE:=yB+yS-1;
						 xB:=0;						 					 
					 for k:=0 to nCOL-1 do
						begin
							if (i<zS) then
							   begin 
							   		 NROI:=Img[..,..,i];							 
							 		 xE:=xB+xS-1;						
							 		 Combo[xB..xE,yB..yE]:=NROI;
							 		 Show(Combo, 'Combo'+ExtractFileName(iNam));
							 		 xB:=xE+Gap+1;
									 i:=i+1;
							 	end	 
									 	 						
						end;
							 yB:=yE+Gap+1;
					end;	
}					
//--------->			
						 	xB:=0;														
				for m:=0 to nCOL-1 do
					begin
						 xE:=xB+xS-1;
						 yB:=0;						 					 
					 for k:=0 to nROW do
						begin
							if (i<zS) then
							   begin 
							   		 NROI:=Img[..,..,i];							 
							 		 yE:=yB+yS-1;						
							 		 Combo[xB..xE,yB..yE]:=NROI;
							 		 Show(Combo, 'Combo'+ExtractFileName(iNam));
							 		 yB:=yE+Gap+1;
									 i:=i+1;
							 	end	 
									 	 						
						end;
							 xB:=xE+Gap+1;
					end;	
					SetDisplayRange( Combo, Min, Max ) ;
					Combo:=Combo+(-65000)*(Combo = 0)+65000*(Combo = 1);
					Show(Combo, 'Combo'+ExtractFileName(iNam));
					SetDisplayRange( Combo, Min, Max ) ;
					
					Save(Combo,ExtractFileDir(iNam)+'\Combo'+ExtractFileName(iNam));
					Delete(Combo);
					Open(ExtractFileDir(iNam)+'\Combo'+ExtractFileName(iNam),Combo);
					Show(Combo, 'Combo'+ExtractFileName(iNam));
					SetDisplayRange( Combo, Min, Max ) ;					

				Delete(NROI);
				Delete(Img);
				Free(Combo);			        
					PlaySound( 'C:\Lib_V++\Mac.wav' ) ;						   
		  end
